#include <stdio.h>
#include "hdos.h"

#define PHYS_TRACK(h,ls)	((ls)/HDOS_SECTORS(h))
#define PHYS_SECTOR(h,ls)	((ls)%HDOS_SECTORS(h))

/************************************************************************
 * NAME:	hdos_putlsect() & hdos_getlsect()
 *
 * DESCR:	write/read a logical sector to floppy.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
hdos_putlsect(struct hdosfs *hdosfs, int lsect, char buf[])
{
    if (lsect >= HDOS_SECTORS(hdosfs)*HDOS_TRACKS(hdosfs) || lsect < 0) {
	return (FALSE);
    }

    return(hdos_putpsect(hdosfs,PHYS_TRACK(hdosfs,lsect),PHYS_SECTOR(hdosfs,lsect),buf));
}

int
hdos_getlsect(struct hdosfs *hdosfs, int lsect, char buf[])
{
    if (lsect >= HDOS_SECTORS(hdosfs)*HDOS_TRACKS(hdosfs) || lsect < 0) {
	return (FALSE);
    }

    return(hdos_getpsect(hdosfs,PHYS_TRACK(hdosfs,lsect),PHYS_SECTOR(hdosfs,lsect),buf));
}

/************************************************************************
 * NAME:	hdos_putpsect()
 *
 * DESCR:	Write physical sector to floppy disk file.
 *
 * ARGS:	
 *
 * RETURNS:	TRUE if OK, FALSE otherwise.
 *
 * NOTES:
 ************************************************************************/
int
hdos_putpsect(struct hdosfs *hdosfs, int track, int sect, char buf[])
{
    return((*hdosfs->pwritesec)(hdosfs->device,0,track,sect+hdosfs->startsec,buf));
}

/************************************************************************
 * NAME:	hdos_getpsect()
 *
 * DESCR:	Read physical sector from floppy disk file.
 *
 * ARGS:	
 *
 * RETURNS:	TRUE if OK, FALSE otherwise.
 *
 * NOTES:
 ************************************************************************/
int
hdos_getpsect(struct hdosfs *hdosfs, int track, int sect, char buf[])
{
    return((hdosfs->preadsec)(hdosfs->device,0,track,sect+hdosfs->startsec,buf));
}

